#pragma once

#include <deque>

class CRFView : public CView
{
protected: // create from serialization only
	CRFView();
	DECLARE_DYNCREATE(CRFView)

public: // Methods
	CRFDoc* GetDocument() const;

public: // Members

private: // Methods
	enum TEXT_JUST { LEFT_JUST = 0, CENTERED = 1, RIGHT_JUST = 2};

	void GlInitialization(void);
	HFONT GetFont(int h, int w, char *name);

	void CreateNewTrace(void);
	void NormalizeTrace(const float *t, double ref, int n);

	void DrawGraticule(void);
	void DrawGratText(void);
	void DrawSweep(void);
	void RastText(const CString &s, TEXT_JUST just, int x, int y);
	void glPrint(const char *s);

private: // Members
	CDC *m_cDC;
	HGLRC m_hRC;

	GLuint m_fontBuf;
	HFONT m_fontHandle;

	int m_winWidth, m_winHeight;
	int m_xGrat, m_yGrat;
	int m_xLeftMarg, m_xRightMarg, m_yTopMarg, m_yBotMarg;

	std::vector<float> m_gratVec;
	GLuint m_gratBuf;

	std::vector<float>* pTrace;
	GLuint m_traceBuf;

// Overrides
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);

// Implementation
public:
	virtual ~CRFView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	afx_msg void OnFilePrintPreview();
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
};

#ifndef _DEBUG  // debug version in SHView.cpp
inline CRFDoc* CRFView::GetDocument() const
   { return reinterpret_cast<CRFDoc*>(m_pDocument); }
#endif

